// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// C include file for MPI multiprecision integer math routines.
//.............................................................

// usuals.h - The usual typedefs, etc.
//....................................
typedef unsigned char boolean;	
typedef unsigned char byte;			
typedef byte *byteptr;			// pointer to byte
typedef char *string;			// pointer to ASCII character string
typedef unsigned short word16;	// values are 0-65535
typedef unsigned long word32;	// values are 0-4294967295

// min and max macros.
//....................
//#define min(a,b) (((a)<(b)) ? (a) : (b) )
//#define max(a,b) (((a)>(b)) ? (a) : (b) )

// void for use in pointers.
//..........................
#ifndef NO_VOID_STAR
#define	VOID	void
#else
#define	VOID	char
#endif

// Zero-fill the byte buffer.
//...........................
#define fill0(buffer,count)	memset(buffer,0,count)

// This macro is for burning sensitive data.  Many of the
// file I/O routines use it for zapping buffers.
//.......................................................
#define burn(x) fill0((VOID *)&(x),sizeof(x))

// Multiprecision add with no carry.
//..................................
#define mp_add(r1,r2) mp_addc(r1,r2,(boolean)0)
	
// platform.h - computer platform customization for PGP
// multiprecision math package.  #Included in mpilib.h.

// The following preprocessor symbols should be conditionally set to 
// optimize for a particular environment.

// Define one of the following:
// UNIT8, UNIT16, or UNIT32	- specifies size of operands for
// multiprecision add, subtract, shift, and initialization operations.

// Define one of the following:
// MUNIT8, MUNIT16, MUNIT32	- specified size of operands for 
// multiprecision multiply and mod_mult.  This must be less than or
// equal to unit size.  It should be the word size for the native
// atomic multiply instruction.  For a 16x16 bit multiply yielding a
// 32-bit product, MUNIT16 should be set.

// Define one (or more) of the following:
// PEASANT, MERRITT, UPTON, SMITH	-algorithm used for modmult.All defined
// algorithms are compiled, but the first defined name listed will be 
// assigned to the generic entry point symbols.  Multiple algorithms are
// used primarily for testing.

// HIGHFIRST - specified if longs are stored with the most significant
// bit at the lowest address (Motorola), undefined otherwise.  This should
// be defined on the command line, normally in the makefile.

// The following symbol, if initialized, is set to specific values:
// ALIGN - variable declaration attribute which forces optimum alignment
// of words, e.g. for VAX C: ALIGN=_align(quadword)

// The following symbols correspond to individual multiprecision routines
// that may be implemented with assembly language.  If they are implemented
// in assembly, the symbols should be defined with the name of the
// corresponding external entry points, e.g., mp_addc=P_ADDC
// mp_setp        - set precision for external routines
// mp_addc        - add with carry
// mp_subb        - subtract with borrow
// mp_rotate_left - rotate left
// mp_compare     - compare
// mp_move        - move
// unitfill0      - zero fill
// mp_smul        - multiply vector by single word *
// mp_smula       - multiply vector by single word and accumulate *
// mp_dmul        - full multiply 
// mp_set_recip   - setup for mp_quo_digit
// mp_quo_digit   - quotient digit for modulus reduction

// Either mp_smul or mp_smula should be defined.  mp_smula provides
// for accumulation to an existing value, while mp_smul is for use of the
// older definition of mp_smul, used in PGP 2.0, which assumed that the high 
// order accumulator word is zero.   Use of mp_smula causes one less word of 
// precision to be used, thereby slightly increasing speed.

// Definitions for 80486 or above.
//................................
#define UNIT32
#define MUNIT32
#define UPTON
//#define mp_addc			P_ADDC
//#define mp_subb			P_SUBB
//#define mp_add			P_ADD
//#define mp_rotate_left  P_ROTATE_LEFT
//#define mp_smula		P_SMULA

//#define PLATFORM_SPECIFIED
//#define WIN32
//#define USE_WIN32_ASSEMBLER

//#include "mpw32asm.h"

// UNIT32 definitions.
//....................
#ifdef  UNIT32
typedef word32 unit;
typedef long signedunit;
#define UNITSIZE 32					// number of bits in a unit
#define LOG_UNITSIZE 5
#define uppermostbit ((unit) 0x80000000L)
#define BYTES_PER_UNIT 4			// number of bytes in a unit 
#define units2bits(n) ((n) << 5)	// fast multiply by UNITSIZE
#define units2bytes(n) ((n) << 2)
#define bits2units(n) (((n)+31) >> 5)
#define bytes2units(n) (((n)+3) >> 2)
#endif

#define power_of_2(b) ((unit) 1 << (b)) // computes power-of-2 bit masks

#define bits2bytes(n) (((n)+7) >> 3)

typedef unit *unitptr;

// Byte ordering stuff.
// These definitions assume LSB comes first.
//..........................................
#define tohigher(n)			(n)			// offset towards higher unit
#define pre_higherunit(r)	(++(r))
#define pre_lowerunit(r)	(--(r))
#define post_higherunit(r)	((r)++)
#define post_lowerunit(r)	((r)--)
#define bit_index(n)		(bits2units((n)+1)-1)
#define lsbptr(r,prec)		(r)
#define make_lsbptr(r,prec)				// (r) = lsbptr(r,prec)  
#define unmake_lsbptr(r,prec)			// (r) = (r)
#define msbptr(r,prec)		((r)+(prec)-1)
#define make_msbptr(r,prec)	(r) = msbptr(r,prec)

#define rescale(r,currentp,newp)		// nil statement
#define normalize(r,prec) prec = significance(r) 

// Note that the address calculations require that lsbptr, msbptr, 
// make_lsbptr, make_msbptr, mp_tstbit, mp_setbit, mp_clrbit, 
// and bitptr all have unitptr arguments, not byte pointer arguments.
//...................................................................
#define bitptr(r,n) &((r)[bit_index(n)])

// bitmsk() assumes UNITSIZE is a power of 2.
//...........................................
#define bitmsk(n) power_of_2((n) & (UNITSIZE-1))
	
#define mp_tstbit(r,n) (*bitptr(r,n) &   bitmsk(n))
#define mp_setbit(r,n) (*bitptr(r,n) |=  bitmsk(n))
#define mp_clrbit(r,n) (*bitptr(r,n) &= ~bitmsk(n))
#define msunit(r) (*msbptr(r,global_precision))
#define lsunit(r) (*lsbptr(r,global_precision))

// #define mp_tstminus(r) ((msunit(r) & uppermostbit)!=0).
//........................................................
#define mp_tstminus(r) ((signedunit) msunit(r) < 0)

// Set gobal precision to the number of units.
//............................................
#define set_precision(prec) (global_precision = (prec))

// Define C names for Upton's modmult primitives.
//...............................................
#ifdef UPTON

#define stage_modulus	stage_upton_modulus
#define mp_modmult		upton_modmult
#define modmult_burn	upton_burn
#define SLOP_BITS		UPTON_SLOP_BITS
#define	SLOP_BYTES		SLOP_BITS/8
#endif

//#define mp_smul	mp_smula

#ifdef  MUNIT32
#define MULTUNITSIZE   32
typedef unsigned long MULTUNIT;
#endif

#ifdef  UNIT32
#define MULTUNIT_SIZE_SAME
#endif

#define MULTUNIT_msb    ((MULTUNIT)1 << (MULTUNITSIZE-1))	
#define DMULTUNIT_msb   (1L << (2*MULTUNITSIZE-1))
#define MULTUNIT_mask   ((MULTUNIT)((1L << MULTUNITSIZE)-1))
#define MULTUNITs_perunit   (UNITSIZE/MULTUNITSIZE)

void mp_smul(MULTUNIT * prod, MULTUNIT * multiplicand, MULTUNIT multiplier);
void mp_dmul(unitptr prod, unitptr multiplicand, unitptr multiplier);

// multiprecision shift left 1 bit.
//.................................
#define mp_shift_left(r1) mp_rotate_left(r1,(boolean)0)
	
// multiprecision subtract with no borrow.
//........................................
#define mp_sub(r1,r2) mp_subb(r1,r2,(boolean)0)
	
#define mp_abs(r) (mp_tstminus(r) ? (mp_neg(r),TRUE) : FALSE)

// Prevents r from getting bigger than modulus m.
//...............................................
#define msub(r,m) if (mp_compare(r,m) >= 0) mp_sub(r,m)
	
#define testeq(r,i)	((lsunit(r) == (i)) && (significance(r) <= 1))

#define testne(r,i)	((lsunit(r) != (i)) || (significance(r) > 1))

#define testge(r,i)	((lsunit(r) >= (i)) || (significance(r) > 1))

#define testle(r,i)	((lsunit(r) <= (i)) && (significance(r) <= 1))

// Square r2, returning product in r1.
//....................................
#define mp_square(r1,r2) mp_mult(r1,r2,r2)
	
// Square r2, returning modulo'ed product in r1.
//..............................................
#define mp_modsquare(r1,r2) mp_modmult(r1,r2,r2)
	
#define countbytes(r) ((countbits(r) + 7) >> 3)

// SLOP_BITS is how many "carry bits" to allow for intermediate
// calculation results to exceed the size of the modulus.
// It is used by modexp to give some overflow elbow room for
// modmult to use to perform modulo operations with the modulus.
// The number of slop bits required is determined by the modmult
// algorithm.  The Russian peasant modmult algorithm only requires
// 1 slop bit, for example.  Note that if we use an external assembly
// modmult routine, SLOP_BITS may be meaningless or may be defined in a
// non-constant manner.
//.....................................................................
#define UPTON_SLOP_BITS	(UNITSIZE*2)

#define MIN_KEY_BITS  480
#define MAX_KEY_BITS  16384

// MAX_BIT_PRECISION is upper limit that assembly primitives can handle.
// It must be less than 32704 bits, or 4088 bytes.  It should be an
// integer multiple of UNITSIZE*2.
//......................................................................
#define MAX_BIT_PRECISION	(MAX_KEY_BITS+(4*UNITSIZE))
#define MAX_BYTE_PRECISION	(MAX_BIT_PRECISION/8)
#define MAX_UNIT_PRECISION	(MAX_BIT_PRECISION/UNITSIZE)


// global_precision is the unit precision last set by set_precision.
// For Win32 we want this to be 32-bit, for compatibility with the assembler code.
//................................................................................
#if defined(WIN32)
extern unsigned int global_precision;
#else
extern short global_precision;
#endif

// The "bit sniffer" macros all begin sniffing at the MSB.
// They are used internally by all the various multiply, divide, 
// modulo, exponentiation, and square root functions.
//..............................................................
#define sniff_bit(bptr,bitmask)	(*(bptr) & bitmask)

#define init_bitsniffer(bptr,bitmask,prec,bits) \
{ normalize(bptr,prec); \
  if (!prec) \
    return(0); \
  bits = units2bits(prec); \
  make_msbptr(bptr,prec); bitmask = uppermostbit; \
  while (!sniff_bit(bptr,bitmask)) \
  { bitmask >>= 1; bits--; \
  } \
}

#define bump_bitsniffer(bptr,bitmask) \
{ if (!(bitmask >>= 1)) \
  { bitmask = uppermostbit; \
	post_lowerunit(bptr); \
  } \
}

// bump_2bitsniffers is used internally by mp_udiv.
//.................................................
#define bump_2bitsniffers(bptr,bptr2,bitmask) \
{ if (!(bitmask >>= 1)) \
  { bitmask = uppermostbit; \
    post_lowerunit(bptr); \
    post_lowerunit(bptr2); \
  } \
}

// stuff_bit is used internally by mp_udiv and mp_sqrt.
//.....................................................
#define stuff_bit(bptr,bitmask)	*(bptr) |= bitmask

// Multiprecision add with carry r2 to r1, result in r1.
//......................................................
boolean mp_addc(register unitptr r1,register unitptr r2,register boolean carry);
	
// Multiprecision subtract with borrow, r2 from r1, result in r1.
//...............................................................
boolean mp_subb(register unitptr r1,register unitptr r2,register boolean borrow);
	
// Multiprecision rotate left 1 bit with carry, result in r1.
//...........................................................
boolean mp_rotate_left(register unitptr r1,register boolean carry);
	
// Multiprecision shift right bits, result in r1.
//...............................................
void mp_shift_right_bits(register unitptr r1,register int bits);
	
// Compares registers *r1, *r2, and returns -1, 0, or 1.
//......................................................
short mp_compare(register unitptr r1,register unitptr r2);
	
// Increment multiprecision integer r.
//....................................
boolean mp_inc(register unitptr r);
	
// Decrement multiprecision integer r.
//....................................
boolean mp_dec(register unitptr r);

#ifndef mp_burn
#define mp_burn(r) mp_init(r,0) /* for burning the evidence */
#define mp_init0(r) mp_init(r,0)
#endif

#define empty_array(r)  unitfill0(r, sizeof(r)/sizeof(r[0])/sizeof(unit))

// Zero-fill the unit buffer r.
//.............................
void unitfill0(unitptr r, word32 unitcount);

// Move one area of memory to another.
//....................................
void mp_move(register unitptr dst, register unitptr src);

// Init multiprecision register r with short value.
//.................................................
void mp_init(register unitptr r, word32 value);
	
// Returns number of significant units in r.
//..........................................
short significance(register unitptr r);
	
// Unsigned divide, treats both operands as positive.
//...................................................
int mp_udiv(register unitptr remainder,register unitptr quotient,
	        register unitptr dividend,register unitptr divisor);
	
// Compute reciprocal as 1/divisor.  Used by faster modmult.
//..........................................................
int mp_recip(register unitptr quotient,register unitptr divisor);

// Unsigned divide, treats both operands as positive.
//...................................................
int mp_mod(register unitptr remainder,
	register unitptr dividend,register unitptr divisor);

// Computes multiprecision prod = multiplicand * multiplier.
//..........................................................
int mp_mult(register unitptr prod,register unitptr multiplicand,
			register unitptr multiplier);
	
// Returns number of significant bits in r.
//.........................................
int countbits(unitptr r);
	
// Must pass modulus to stage_modulus before calling modmult.
//...........................................................
int stage_upton_modulus(unitptr n);
	
// Performs combined multiply/modulo operation, with global modulus.
//..................................................................
int upton_modmult(register unitptr prod,unitptr multiplicand,
				  register unitptr multiplier);

// Combined exponentiation/modulo algorithm.
//..........................................
int mp_modexp(register unitptr expout,register unitptr expin,
			  register unitptr exponent,register unitptr modulus);
	
// exponentiation and modulo using Chinese Remainder Theorem.
//...........................................................
int mp_modexp_crt(unitptr expout, unitptr expin,
	unitptr p, unitptr q, unitptr ep, unitptr eq, unitptr u);

// Computes greatest common divisor via Euclid's algorithm.
//.........................................................
void mp_gcd(unitptr result, unitptr a, unitptr n);
	 
// Euclid's algorithm extended to compute multiplicative inverse.
// Computes x such that a*x mod n = 1, where 0 < a < n.
//...............................................................
void mp_inv(unitptr x, unitptr a, unitptr n);
